PACKAGE fourpack IS
  TYPE fourval IS (X, L, H, Z);
  TYPE fourval_vector IS ARRAY (natural RANGE <> ) OF fourval;

  FUNCTION resolve( s: fourval_vector) RETURN fourval;
END fourpack;

PACKAGE BODY fourpack IS
  FUNCTION resolve( s: fourval_vector) RETURN fourval IS
    VARIABLE result : fourval := Z;
  BEGIN
    FOR i IN s'RANGE LOOP
      CASE result IS
        WHEN Z =>
          CASE s(i) IS
            WHEN H =>
              result := H;
            WHEN L =>
              result := L;
            WHEN X =>
              result := X;
            WHEN OTHERS =>
              NULL;
          END CASE;

        WHEN L =>
          CASE s(i) IS
            WHEN H =>
              result := X;
            WHEN X =>
              result := X;
            WHEN OTHERS =>
              NULL;
          END CASE;

        WHEN H =>
          CASE s(i) IS
            WHEN L =>
              result := X;
            WHEN X =>
              result := X;
            WHEN OTHERS =>
              NULL;
          END CASE;

        WHEN X =>
          result := X;

      END CASE;
    END LOOP;
    RETURN result;
  END resolve;
END fourpack;



PACKAGE ninepack IS
  TYPE strength IS (Z, R, F);
  TYPE nineval IS ( Z0, Z1, ZX,
                    R0, R1, RX,
                    F0, F1, FX );

  TYPE ninevalvec IS ARRAY(natural RANGE <>) OF nineval;

  TYPE ninevaltab IS ARRAY(nineval'LOW TO
      nineval'HIGH) OF strength;

  TYPE strengthtab IS ARRAY(strength'LOW TO
      strength'HIGH) OF nineval;

  FUNCTION resolve9( s: ninevalvec) RETURN nineval;

END ninepack;



PACKAGE BODY ninepack IS
  FUNCTION resolve9( s: ninevalvec) RETURN nineval IS
    VARIABLE result: nineval;
    CONSTANT get_strength : ninevaltab :=
        (Z,    --Z0
         Z,    --Z1
         Z,    --ZX
         R,    --R0
         R,    --R1
         R,    --RX
         F,    --F0
         F,    --F1
         F);   --FX

  CONSTANT x_tab :  strengthtab :=
        (ZX,   --Z
         RX,   --R
         FX);  --F
  BEGIN
    IF s'LENGTH = 0 THEN RETURN ZX; END IF;
    result := s(0);

    FOR i IN s'RANGE LOOP
      IF get_strength(result) < get_strength(s(i)) THEN
        result := s(i);

      ELSIF get_strength(result) = get_strength(s(i)) THEN
        IF result /= s(i) THEN
          result := x_tab(get_strength(result));
        END IF;

      END IF;
    END LOOP;
    RETURN result;

  END resolve9;
END ninepack;

